/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.wishingforsunshine.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import noobanidus.mods.wishingforsunshine.config.ConfigManager;
import noobanidus.mods.wishingforsunshine.config.ItemType;
import noobanidus.mods.wishingforsunshine.init.ModBlocks;

public class WellCategory
implements IRecipeCategory<WellRecipe> {
    public static ResourceLocation UID = new ResourceLocation("wishingforsunshine", "well_category");
    public static ResourceLocation BACKGROUND = new ResourceLocation("wishingforsunshine", "textures/gui/wishing_well_jei.png");
    public static ResourceLocation MIDDAY = new ResourceLocation("wishingforsunshine", "textures/gui/midday.png");
    public static ResourceLocation MIDNIGHT = new ResourceLocation("wishingforsunshine", "textures/gui/midnight.png");
    public static ResourceLocation RAIN = new ResourceLocation("wishingforsunshine", "textures/gui/rain.png");
    public static ResourceLocation SUNRISE = new ResourceLocation("wishingforsunshine", "textures/gui/sunrise.png");
    public static ResourceLocation SUNSET = new ResourceLocation("wishingforsunshine", "textures/gui/sunset.png");
    public static ResourceLocation SUNSHINE = new ResourceLocation("wishingforsunshine", "textures/gui/sunshine.png");
    public static ResourceLocation THUNDER = new ResourceLocation("wishingforsunshine", "textures/gui/thunder.png");
    public static final int WIDTH = 72;
    public static final int HEIGHT = 28;
    public final IDrawable background;
    public final IDrawable icon;
    public final IDrawable midday;
    public final IDrawable midnight;
    public final IDrawable rain;
    public final IDrawable sunrise;
    public final IDrawable sunset;
    public final IDrawable sunshine;
    public final IDrawable thunder;
    public static List<WellRecipe> RECIPE_LIST = Stream.of(ItemType.values()).map(WellRecipe::new).collect(Collectors.toList());

    public WellCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 72, 28).addPadding(5, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.WELL.get()));
        this.midday = guiHelper.drawableBuilder(MIDDAY, 0, 0, 24, 24).setTextureSize(24, 24).build();
        this.midnight = guiHelper.drawableBuilder(MIDNIGHT, 0, 0, 24, 24).setTextureSize(24, 24).build();
        this.rain = guiHelper.drawableBuilder(RAIN, 0, 0, 24, 24).setTextureSize(24, 24).build();
        this.sunrise = guiHelper.drawableBuilder(SUNRISE, 0, 0, 24, 24).setTextureSize(24, 24).build();
        this.sunset = guiHelper.drawableBuilder(SUNSET, 0, 0, 24, 24).setTextureSize(24, 24).build();
        this.sunshine = guiHelper.drawableBuilder(SUNSHINE, 0, 0, 24, 24).setTextureSize(24, 24).build();
        this.thunder = guiHelper.drawableBuilder(THUNDER, 0, 0, 24, 24).setTextureSize(24, 24).build();
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends WellRecipe> getRecipeClass() {
        return WellRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"wishingforsunshine.jei.well", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(WellRecipe recipe, MatrixStack stack, double mouseX, double mouseY) {
        IDrawable toDraw = null;
        switch (recipe.getType()) {
            case MIDDAY: {
                toDraw = this.midday;
                break;
            }
            case MIDNIGHT: {
                toDraw = this.midnight;
                break;
            }
            case RAIN: {
                toDraw = this.rain;
                break;
            }
            case SUNRISE: {
                toDraw = this.sunrise;
                break;
            }
            case SUNSET: {
                toDraw = this.sunset;
                break;
            }
            case SUNSHINE: {
                toDraw = this.sunshine;
                break;
            }
            case THUNDER: {
                toDraw = this.thunder;
            }
        }
        if (toDraw == null) {
            return;
        }
        toDraw.draw(stack, 42, 6);
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        int stringWidth = fr.func_78256_a(recipe.getName());
        fr.func_238421_b_(stack, recipe.getName(), (float)(this.background.getWidth() - stringWidth) / 2.0f, 0.0f, -8355712);
    }

    public void setIngredients(WellRecipe wellRecipe, IIngredients iIngredients) {
        iIngredients.setInput(VanillaTypes.ITEM, (Object)wellRecipe.getInput());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, WellRecipe wellRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup group = iRecipeLayout.getItemStacks();
        group.init(0, true, 3, 10);
        group.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
    }

    public static class WellRecipe {
        private ItemType type;
        private String name;

        public WellRecipe(ItemType type) {
            this.type = type;
            this.name = I18n.func_135052_a((String)("wishingforsunshine.type." + type.name().toLowerCase()), (Object[])new Object[0]);
        }

        public ItemType getType() {
            return this.type;
        }

        public ItemStack getInput() {
            return ConfigManager.getItemForType(this.type);
        }

        public String getName() {
            return this.name;
        }
    }
}

